/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.config;

import cofh.lib.config.IBaseConfig;
import cofh.thermal.cultivation.init.TCulReferences;
import cofh.thermal.cultivation.item.WateringCanItem;
import net.minecraftforge.common.ForgeConfigSpec;

public class TCulToolConfig
implements IBaseConfig {
    private ForgeConfigSpec.IntValue wateringCanCapacity;
    private ForgeConfigSpec.BooleanValue wateringCanFakePlayers;
    private ForgeConfigSpec.BooleanValue wateringCanSourceBlocks;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Tools");
        builder.push("Watering Can");
        this.wateringCanCapacity = builder.comment("This sets the maximum base fluid capacity for the Watering Can.").defineInRange("Base Capacity", 4000, 1000, 10000000);
        this.wateringCanFakePlayers = builder.comment("If TRUE, the Watering Can can be used by Fake Players.").define("Allow Fake Players", WateringCanItem.allowFakePlayers);
        this.wateringCanSourceBlocks = builder.comment("If TRUE, the Watering Can consumes source blocks when refilling.").define("Consume Source Blocks", WateringCanItem.removeSourceBlocks);
        builder.pop();
        builder.pop();
    }

    public void refresh() {
        if (TCulReferences.WATERING_CAN_ITEM == null) {
            return;
        }
        TCulReferences.WATERING_CAN_ITEM.setFluidCapacity((Integer)this.wateringCanCapacity.get());
        WateringCanItem.allowFakePlayers = (Boolean)this.wateringCanFakePlayers.get();
        WateringCanItem.removeSourceBlocks = (Boolean)this.wateringCanSourceBlocks.get();
    }
}

